/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;

public class VelocityService
implements Bootable {
    private VelocityLogger logger = null;
    private Map<Manifest, VelocityEngine> engines = new HashMap<Manifest, VelocityEngine>();
    private VelocityEngine defaultEngine = null;

    public Class[] depends() {
        return new Class[]{LogService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        try {
            Application.getCallback().getStartupMonitor().setStatusText("init velocity template engine");
            this.logger = new VelocityLogger();
            this.defaultEngine = new VelocityEngine();
            this.defaultEngine.setProperty("runtime.log.logsystem", (Object)this.logger);
            this.defaultEngine.init();
        }
        catch (Exception e) {
            throw new SkipServiceException((Bootable)this, "unable to init velocity engine", (Throwable)e);
        }
    }

    public void shutdown() {
        this.engines.clear();
        this.logger = null;
        this.defaultEngine = null;
    }

    private VelocityEngine get(Manifest mf) {
        if (mf == null) {
            return null;
        }
        VelocityEngine e = null;
        e = this.engines.get(mf);
        if (e != null) {
            return e;
        }
        File templates = new File(mf.getPluginDir() + File.separator + "lib", "velocity");
        if (!templates.exists()) {
            Logger.debug((String)("plugin " + mf.getName() + " contains no lib/velocity dir"));
            return null;
        }
        try {
            Logger.debug((String)("init velocity engine for plugin " + mf.getName()));
            e = new VelocityEngine();
            e.setProperty("runtime.log.logsystem", (Object)this.logger);
            e.setProperty("file.resource.loader.path", (Object)templates.getAbsolutePath());
            e.init();
            this.engines.put(mf, e);
            return e;
        }
        catch (Exception ex) {
            Logger.error((String)("unable to init velocity engine for plugin " + mf.getName()), (Throwable)ex);
            return null;
        }
    }

    public VelocityEngine getEngine(String plugin) {
        if (plugin == null || plugin.length() == 0) {
            return this.defaultEngine;
        }
        List<Manifest> list = Application.getPluginLoader().getInstalledManifests();
        for (Manifest mf : list) {
            VelocityEngine e;
            String name = mf.getName();
            String clazz = mf.getPluginClass();
            if (name == null || clazz == null || !name.equals(plugin) && !clazz.equals(plugin) || (e = this.get(mf)) == null) continue;
            return e;
        }
        return this.defaultEngine;
    }

    public String merge(String source, Map<String, Object> context) throws IOException {
        VelocityContext vc = new VelocityContext(context);
        StringWriter target = new StringWriter();
        this.defaultEngine.evaluate((Context)vc, (Writer)target, "merge", source);
        return target.toString();
    }

    static class VelocityLogger
    implements LogChute {
        VelocityLogger() {
        }

        public void init(RuntimeServices rs) throws Exception {
        }

        public boolean isLevelEnabled(int level) {
            return false;
        }

        public void log(int level, String msg) {
            this.log(level, msg, null);
        }

        public void log(int level, String msg, Throwable t) {
            switch (level) {
                case 1: {
                    Logger.debug((String)msg);
                    break;
                }
                case 2: {
                    Logger.warn((String)msg);
                    break;
                }
                case 3: {
                    Logger.error((String)msg, (Throwable)t);
                    break;
                }
                case 0: {
                    Logger.debug((String)msg);
                    break;
                }
                case -1: {
                    Logger.trace((String)msg);
                    break;
                }
                default: {
                    Logger.debug((String)msg);
                }
            }
        }
    }
}

